#include "CameraCBuffer.hlsli"
#include "SamplerStates.hlsli"

// The rendertarget to render
Texture2D RenderTargetTex : register(t0);

struct PSInput {
	float4 Position : SV_Position;
	float2 TexCoords : TEXCOORD0;
};

#include "Common.hlsli"
#include "Tonemapping.hlsli"
#include "FilmGrain.hlsli"

float4 main(PSInput input) : SV_TARGET
{
	float4 color = RenderTargetTex.SampleLevel(LinearSampler, input.TexCoords, 0);
	return ApplyTonemapping(color) + Noise(input.TexCoords);
}